  
    
				// Funcionalidad del Carousel - Navegación con botones
document.addEventListener('DOMContentLoaded', function() {
    const carousel = document.getElementById('carousel-promotion');
    const track = carousel.querySelector('.slick-track');
    const slides = carousel.querySelectorAll('.slick-slide');
    const prevButton = carousel.querySelector('.btnIcon--left');
    const nextButton = carousel.querySelector('.btnIcon--right');
    
    let currentIndex = 0;
    const slideWidth = 417; // Ancho de cada slide según el HTML
    const visibleSlides = 3; // Número de slides visibles al mismo tiempo
    const totalSlides = slides.length;
    const maxIndex = totalSlides - visibleSlides;
    
    // Función para actualizar la posición del carousel
    function updateCarouselPosition() {
        const translateX = -(currentIndex * slideWidth);
        track.style.transform = `translate3d(${translateX}px, 0px, 0px)`;
        
        // Actualizar clases de slides activos
        updateActiveSlides();
        
        // Actualizar estado de los botones
        updateButtonStates();
    }
    
    // Función para actualizar slides activos
    function updateActiveSlides() {
        slides.forEach((slide, index) => {
            slide.classList.remove('slick-current', 'slick-active');
            slide.setAttribute('aria-hidden', 'true');
            slide.setAttribute('tabindex', '-1');
            
            // Marcar slides visibles como activos
            if (index >= currentIndex && index < currentIndex + visibleSlides) {
                slide.classList.add('slick-active');
                slide.setAttribute('aria-hidden', 'false');
                slide.setAttribute('tabindex', '0');
                
                // El primer slide visible es el current
                if (index === currentIndex) {
                    slide.classList.add('slick-current');
                }
            }
        });
    }
    
    // Función para actualizar estado de los botones
    function updateButtonStates() {
        // Botón Previous
        if (currentIndex <= 0) {
            prevButton.setAttribute('aria-disabled', 'true');
            prevButton.style.opacity = '0.5';
            prevButton.style.cursor = 'not-allowed';
        } else {
            prevButton.setAttribute('aria-disabled', 'false');
            prevButton.style.opacity = '1';
            prevButton.style.cursor = 'pointer';
        }
        
        // Botón Next
        if (currentIndex >= maxIndex) {
            nextButton.setAttribute('aria-disabled', 'true');
            nextButton.style.opacity = '0.5';
            nextButton.style.cursor = 'not-allowed';
        } else {
            nextButton.setAttribute('aria-disabled', 'false');
            nextButton.style.opacity = '1';
            nextButton.style.cursor = 'pointer';
        }
    }
    
    // Event listener para botón Previous
    prevButton.addEventListener('click', function() {
        if (currentIndex > 0) {
            currentIndex--;
            updateCarouselPosition();
        }
    });
    
    // Event listener para botón Next
    nextButton.addEventListener('click', function() {
        if (currentIndex < maxIndex) {
            currentIndex++;
            updateCarouselPosition();
        }
    });
    
    // Soporte para navegación con teclado
    prevButton.addEventListener('keydown', function(e) {
        if (e.key === 'Enter' || e.key === ' ') {
            e.preventDefault();
            prevButton.click();
        }
    });
    
    nextButton.addEventListener('keydown', function(e) {
        if (e.key === 'Enter' || e.key === ' ') {
            e.preventDefault();
            nextButton.click();
        }
    });
    
    // Funcionalidad de deslizar con mouse/touch (opcional)
    let isDragging = false;
    let startX = 0;
    let currentTranslate = 0;
    let prevTranslate = 0;
    
    // Mouse events
    track.addEventListener('mousedown', dragStart);
    track.addEventListener('mousemove', drag);
    track.addEventListener('mouseup', dragEnd);
    track.addEventListener('mouseleave', dragEnd);
    
    // Touch events
    track.addEventListener('touchstart', dragStart);
    track.addEventListener('touchmove', drag);
    track.addEventListener('touchend', dragEnd);
    
    function dragStart(e) {
        isDragging = true;
        startX = getPositionX(e);
        prevTranslate = currentIndex * slideWidth;
        track.style.transition = 'none';
    }
    
    function drag(e) {
        if (!isDragging) return;
        e.preventDefault();
        
        const currentX = getPositionX(e);
        const deltaX = currentX - startX;
        currentTranslate = prevTranslate - deltaX;
        
        track.style.transform = `translate3d(-${currentTranslate}px, 0px, 0px)`;
    }
    
    function dragEnd() {
        if (!isDragging) return;
        isDragging = false;
        
        track.style.transition = 'transform 0.3s ease';
        
        const movedBy = currentTranslate - prevTranslate;
        
        // Si se movió más de 100px, cambiar slide
        if (movedBy > 100 && currentIndex < maxIndex) {
            currentIndex++;
        } else if (movedBy < -100 && currentIndex > 0) {
            currentIndex--;
        }
        
        updateCarouselPosition();
    }
    
    function getPositionX(e) {
        return e.type.includes('mouse') ? e.clientX : e.touches[0].clientX;
    }
    
    // Auto-play opcional (descomenta si lo necesitas)
    /*
    let autoPlayInterval;
    
    function startAutoPlay() {
        autoPlayInterval = setInterval(() => {
            if (currentIndex < maxIndex) {
                currentIndex++;
            } else {
                currentIndex = 0; // Volver al inicio
            }
            updateCarouselPosition();
        }, 4000); // Cambiar cada 4 segundos
    }
    
    function stopAutoPlay() {
        clearInterval(autoPlayInterval);
    }
    
    // Pausar auto-play al hacer hover
    carousel.addEventListener('mouseenter', stopAutoPlay);
    carousel.addEventListener('mouseleave', startAutoPlay);
    
    // Iniciar auto-play
    startAutoPlay();
    */
    
    // Inicializar el carousel
    updateCarouselPosition();
    
    // Responsive: Recalcular en resize
    window.addEventListener('resize', function() {
        updateCarouselPosition();
    });
});
		
 
        // Funcionalidad del Carousel de Vacaciones - Navegación con botones
document.addEventListener('DOMContentLoaded', function() {
    const carousel = document.getElementById('carousel-vacation'); // Cambiado de 'carousel-promotion' a 'carousel-vacation'
    
    // Verificar que el carousel existe
    if (!carousel) {
        console.error('Carousel no encontrado');
        return;
    }
    
    const track = carousel.querySelector('.slick-track');
    const slides = carousel.querySelectorAll('.slick-slide');
    const prevButton = document.getElementById('prevBtn'); // Usar los IDs específicos de los botones
    const nextButton = document.getElementById('nextBtn');
    
    // Verificar que todos los elementos existen
    if (!track || !slides.length || !prevButton || !nextButton) {
        console.error('Elementos del carousel no encontrados');
        return;
    }
    
    let currentIndex = 0;
    const slideWidth = 417; // Ancho de cada slide según el HTML
    const visibleSlides = 3; // Número de slides visibles al mismo tiempo
    const totalSlides = slides.length;
    const maxIndex = Math.max(0, totalSlides - visibleSlides); // Asegurar que no sea negativo
    
    // Función para actualizar la posición del carousel
    function updateCarouselPosition() {
        const translateX = -(currentIndex * slideWidth);
        track.style.transform = `translate3d(${translateX}px, 0px, 0px)`;
        
        // Actualizar clases de slides activos
        updateActiveSlides();
        
        // Actualizar estado de los botones
        updateButtonStates();
    }
    
    // Función para actualizar slides activos
    function updateActiveSlides() {
        slides.forEach((slide, index) => {
            slide.classList.remove('slick-current', 'slick-active');
            slide.setAttribute('aria-hidden', 'true');
            
            // Encontrar los enlaces dentro del slide para actualizar tabindex
            const links = slide.querySelectorAll('a');
            links.forEach(link => link.setAttribute('tabindex', '-1'));
            
            // Marcar slides visibles como activos
            if (index >= currentIndex && index < currentIndex + visibleSlides) {
                slide.classList.add('slick-active');
                slide.setAttribute('aria-hidden', 'false');
                
                // Restaurar tabindex para enlaces visibles
                links.forEach(link => link.setAttribute('tabindex', '0'));
                
                // El primer slide visible es el current
                if (index === currentIndex) {
                    slide.classList.add('slick-current');
                }
            }
        });
    }
    
    // Función para actualizar estado de los botones
    function updateButtonStates() {
        // Botón Previous
        if (currentIndex <= 0) {
            prevButton.setAttribute('aria-disabled', 'true');
            prevButton.style.opacity = '0.5';
            prevButton.style.cursor = 'not-allowed';
            prevButton.disabled = true;
        } else {
            prevButton.setAttribute('aria-disabled', 'false');
            prevButton.style.opacity = '1';
            prevButton.style.cursor = 'pointer';
            prevButton.disabled = false;
        }
        
        // Botón Next
        if (currentIndex >= maxIndex) {
            nextButton.setAttribute('aria-disabled', 'true');
            nextButton.style.opacity = '0.5';
            nextButton.style.cursor = 'not-allowed';
            nextButton.disabled = true;
        } else {
            nextButton.setAttribute('aria-disabled', 'false');
            nextButton.style.opacity = '1';
            nextButton.style.cursor = 'pointer';
            nextButton.disabled = false;
        }
    }
    
    // Event listener para botón Previous
    prevButton.addEventListener('click', function(e) {
        e.preventDefault();
        if (currentIndex > 0) {
            currentIndex--;
            updateCarouselPosition();
        }
    });
    
    // Event listener para botón Next
    nextButton.addEventListener('click', function(e) {
        e.preventDefault();
        if (currentIndex < maxIndex) {
            currentIndex++;
            updateCarouselPosition();
        }
    });
    
    // Soporte para navegación con teclado
    prevButton.addEventListener('keydown', function(e) {
        if (e.key === 'Enter' || e.key === ' ') {
            e.preventDefault();
            if (!prevButton.disabled) {
                prevButton.click();
            }
        }
    });
    
    nextButton.addEventListener('keydown', function(e) {
        if (e.key === 'Enter' || e.key === ' ') {
            e.preventDefault();
            if (!nextButton.disabled) {
                nextButton.click();
            }
        }
    });
    
    // Funcionalidad de deslizar con mouse/touch
    let isDragging = false;
    let startX = 0;
    let currentTranslate = 0;
    let prevTranslate = 0;
    
    // Mouse events
    track.addEventListener('mousedown', dragStart);
    track.addEventListener('mousemove', drag);
    track.addEventListener('mouseup', dragEnd);
    track.addEventListener('mouseleave', dragEnd);
    
    // Touch events para dispositivos móviles
    track.addEventListener('touchstart', dragStart, { passive: false });
    track.addEventListener('touchmove', drag, { passive: false });
    track.addEventListener('touchend', dragEnd);
    
    function dragStart(e) {
        isDragging = true;
        startX = getPositionX(e);
        prevTranslate = currentIndex * slideWidth;
        track.style.transition = 'none';
        
        // Prevenir selección de texto
        track.style.userSelect = 'none';
    }
    
    function drag(e) {
        if (!isDragging) return;
        e.preventDefault();
        
        const currentX = getPositionX(e);
        const deltaX = currentX - startX;
        currentTranslate = prevTranslate - deltaX;
        
        // Limitar el arrastre
        const maxTranslate = maxIndex * slideWidth;
        currentTranslate = Math.max(0, Math.min(currentTranslate, maxTranslate));
        
        track.style.transform = `translate3d(-${currentTranslate}px, 0px, 0px)`;
    }
    
    function dragEnd() {
        if (!isDragging) return;
        isDragging = false;
        
        track.style.transition = 'transform 0.3s ease';
        track.style.userSelect = '';
        
        const movedBy = currentTranslate - prevTranslate;
        
        // Si se movió más de 100px, cambiar slide
        if (movedBy > 100 && currentIndex < maxIndex) {
            currentIndex++;
        } else if (movedBy < -100 && currentIndex > 0) {
            currentIndex--;
        }
        
        updateCarouselPosition();
    }
    
    function getPositionX(e) {
        return e.type.includes('mouse') ? e.clientX : e.touches[0].clientX;
    }
    
    // Auto-play opcional (descomenta si lo necesitas)
    /*
    let autoPlayInterval;
    
    function startAutoPlay() {
        autoPlayInterval = setInterval(() => {
            if (currentIndex < maxIndex) {
                currentIndex++;
            } else {
                currentIndex = 0; // Volver al inicio
            }
            updateCarouselPosition();
        }, 4000); // Cambiar cada 4 segundos
    }
    
    function stopAutoPlay() {
        clearInterval(autoPlayInterval);
    }
    
    // Pausar auto-play al hacer hover
    carousel.addEventListener('mouseenter', stopAutoPlay);
    carousel.addEventListener('mouseleave', startAutoPlay);
    
    // Iniciar auto-play
    startAutoPlay();
    */
    
    // Inicializar el carousel
    updateCarouselPosition();
    
    // Responsive: Recalcular en resize de ventana
    let resizeTimeout;
    window.addEventListener('resize', function() {
        clearTimeout(resizeTimeout);
        resizeTimeout = setTimeout(() => {
            // Recalcular dimensiones si es necesario
            updateCarouselPosition();
        }, 250);
    });
    
    // Agregar smooth scrolling transition al track
    track.style.transition = 'transform 0.3s ease';
});
    


    
        document.addEventListener("DOMContentLoaded", function() {
            if (performance.navigation.type == 2) {
                location.reload();
            }

            // Obtén la fecha actual
            const today = new Date();
            const tomorrow = new Date(today);
            tomorrow.setDate(today.getDate() + 1);

            // Función para formatear las fechas en YYYY-MM-DD
            function formatDateToYMD(date) {
                const year = date.getFullYear();
                const month = String(date.getMonth() + 1).padStart(2, '0');
                const day = String(date.getDate()).padStart(2, '0');
                return `${year}-${month}-${day}`;
            }

            // Función para formatear las fechas en YYYY-MM-DD HH:MM:SS followed by T00:00:00
            function formatDateToYMDHMS(date) {
                const year = date.getFullYear();
                const month = String(date.getMonth() + 1).padStart(2, '0');
                const day = String(date.getDate()).padStart(2, '0');
                const hours = String(date.getHours()).padStart(2, '0');
                const minutes = String(date.getMinutes()).padStart(2, '0');
                const seconds = String(date.getSeconds()).padStart(2, '0');
                return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}T00:00:00`;
            }

            // Configura los datos del objeto __pt.data con fechas dinámicas
            window.__pt.data = {
                "adults": 1,
                "addFirst": "",
                "landing": "home",
                "agekids": "",
                "airlineCode": "",
                "checkIn": formatDateToYMD(today),
                "checkOut": formatDateToYMDHMS(tomorrow),
                "kids": 0,
                "mode": 0,
                "page": 0,
                "returningFromAirport": null,
                "returningFromDateTime": formatDateToYMDHMS(tomorrow),
                "startingFromAirport": null,
                "startingFromDateTime": formatDateToYMD(tomorrow),
                "startingDate": today.toISOString(),
                "returningDate": formatDateToYMDHMS(tomorrow),
                "returningAirportPlace": {
                    "airport": "",
                    "airportCode": "",
                    "airportType": 11,
                    "city": "",
                    "cityFullName": "",
                    "cityName": null,
                    "cityCountryName": null,
                    "countryISO": null
                },
                "startingAirportPlace": {
                    "airport": "",
                    "airportCode": "",
                    "airportType": 11,
                    "city": "",
                    "cityFullName": "",
                    "cityName": null,
                    "cityCountryName": null,
                    "countryISO": null
                },
                "tripMode": 1,
                "daysInAdvance": 0,
                "isNational": false,
                "isRoundtrip": false,
                "paxes": [{
                    "adults": 1,
                    "children": []
                }]
            };
        });
    
    
        // Función para detectar cambios en un input y guardar su valor en localStorage
        function monitorInput(input, localStorageKey) {
            if (!input) {
                console.error(`No se encontró el input para la clave: ${localStorageKey}`);
                return; // Si no existe el input, no hace nada
            }
    
            // Cargar el valor almacenado en localStorage (si existe)
            const storedValue = localStorage.getItem(localStorageKey);
            if (storedValue) {
                input.value = storedValue; // Restaura el valor almacenado en el input
            }
    
            // Detectar cuando el usuario escribe en el input
            input.addEventListener("input", function () {
                localStorage.setItem(localStorageKey, input.value); // Guardar el valor en localStorage
            });
        }
    
        // Configuración de los inputs cuando se carga la página
        document.addEventListener("DOMContentLoaded", function () {
            // Monitorear el input de "origen" por su ID
            const originInput = document.querySelector('input[placeholder="Origen?"], input.suggestion-input-starting');
            monitorInput(originInput, "inputOrigen");
    
            // Monitorear el input de "destino" utilizando un selector más flexible
            const destinationInput = document.querySelector(
                'input[placeholder="Cual es tu destino?"], input.suggestion-input-ending'
            );
            monitorInput(destinationInput, "inputnano2");
        });
    

        // Función para monitorear cambios en un input y guardar su valor en localStorage
        function monitorInput(selector, localStorageKey) {
            const input = document.querySelector(selector); // Selecciona el input según el selector
            if (!input) {
                console.error(`No se encontró el input con el selector: ${selector}`);
                return; // Si no existe el input, no hace nada
            }
    
            // Cargar el valor almacenado en localStorage (si existe)
            const storedValue = localStorage.getItem(localStorageKey);
            if (storedValue) {
                input.value = storedValue; // Restaura el valor almacenado en el input
            }
    
            // Detectar cuando el usuario escribe en el input
            input.addEventListener("input", function () {
                localStorage.setItem(localStorageKey, input.value); // Guardar el valor en localStorage
            });
        }
    
        // Configuración de los inputs cuando se carga la página
        document.addEventListener("DOMContentLoaded", function () {
            // Monitorear el input de "origen" y guardarlo en "inputOriginMobile"
            monitorInput('#origin-mobile', 'inputnano');
    
            // Monitorear el input de "destino" y guardarlo en "inputDestino"
            monitorInput('#destination-mobile', 'inputnano2');
        });
 
    
    


        document.addEventListener("DOMContentLoaded", function () {
            // Crear un observer para observar cambios en el DOM
            const observer = new MutationObserver(function (mutationsList, observer) {
                // Buscamos el input de destino
                const destinationInput = document.querySelector("#destination-mobile");
    
                if (destinationInput) {
                    
                    // Recuperamos el valor almacenado en localStorage (si existe)
                    const storedValue = localStorage.getItem("inputnano2");
                    if (storedValue) {
                        destinationInput.value = storedValue; // Restauramos el valor almacenado
                    }
    
                    // Detectamos el evento de input y guardamos el valor en localStorage
                    destinationInput.addEventListener("input", function (e) {
                        const value = e.target.value;
                        localStorage.setItem("inputnano2", value); // Guardar el valor en localStorage
                    });
    
                    // Dejar de observar una vez que lo encontremos
                    observer.disconnect();
                }
            });
    
            // Configuración del observer para observar los cambios en el body
            observer.observe(document.body, { childList: true, subtree: true });
        });



        // Función para monitorear un input cuando esté disponible
        function monitorInputWhenAvailable(selector, localStorageKey) {
            const observer = new MutationObserver(() => {
                const input = document.querySelector(selector); // Intentar encontrar el input
                if (input) {
                    observer.disconnect(); // Detener el observador cuando se encuentre el input
    
                    // Cargar el valor del localStorage (si existe)
                    const storedValue = localStorage.getItem(localStorageKey);
                    if (storedValue) {
                        input.value = storedValue; // Restaura el valor guardado
                    }
    
                    // Escuchar cambios en el input y guardar el valor en localStorage
                    input.addEventListener("input", function () {
                        localStorage.setItem(localStorageKey, input.value);
                    });
                }
            });
    
            // Configurar el observador para observar cambios en el cuerpo del documento
            observer.observe(document.body, { childList: true, subtree: true });
        }
    
        // Configuración para los inputs de origen y destino
        document.addEventListener("DOMContentLoaded", function () {
            // Monitorear el input de "origen" en móviles
            monitorInputWhenAvailable(
                '.suggestion-input-starting.i-mobile[placeholder="Cual es tu origen?"]',
                "inputnano"
            );
    
            // Monitorear el input de "destino" en móviles
            monitorInputWhenAvailable(
                '.suggestion-input-starting.i-mobile[placeholder="Cual es tu destino?"]',
                "inputDestinationMobile"
            );
        });

        // Función para detectar cambios en un input y guardar su valor en localStorage
        function monitorInput(selector, localStorageKey) {
            const input = document.querySelector(selector); // Selecciona el input según el selector
            if (!input) {
                console.error(`No se encontró el input con el selector: ${selector}`);
                return; // Si no existe el input, no hace nada
            }
    
            // Cargar el valor del localStorage (si existe)
            const storedValue = localStorage.getItem(localStorageKey);
            if (storedValue) {
                input.value = storedValue; // Restaura el valor guardado
            }
    
            // Evento para detectar cuando el usuario escribe en el input
            input.addEventListener('input', function () {
                // Guardar el valor del input en localStorage
                localStorage.setItem(localStorageKey, input.value);
            });
        }
    
        // Configuración de los inputs al cargar la página
        document.addEventListener('DOMContentLoaded', function () {
            // Monitorear el input de "origen"
            monitorInput('#origin', 'inputnano');
    
            // Monitorear el input de "destino"
            monitorInput('#destination', 'inputnano2');
        });

    

        document.addEventListener("DOMContentLoaded", function () {
            const keysToMonitor = ["inputnano", "inputnano2"]; // Claves en localStorage que deseas monitorear
            let previousValues = {}; // Valores iniciales
            let isRequestInProgress = {}; // Estado de solicitud para cada clave
    
            // Inicializar valores previos y estados
            keysToMonitor.forEach((key) => {
                previousValues[key] = localStorage.getItem(key);
                isRequestInProgress[key] = false;
            });
    
            const checkLocalStorage = () => {
                keysToMonitor.forEach((key) => {
                    const currentValue = localStorage.getItem(key);
    
                    // Si el valor ha cambiado y no estamos enviando una solicitud
                    if (currentValue && currentValue !== previousValues[key] && !isRequestInProgress[key]) {
                        previousValues[key] = currentValue; // Actualizar el valor previo
    
                        // Enviar el valor al servidor
                        sendToServer(key, currentValue);
                    }
                });
            };
    
            const sendToServer = (key, value) => {
                isRequestInProgress[key] = true; // Marcar que estamos procesando una solicitud para esta clave
    
    
                fetch("datos.php", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json",
                    },
                    body: JSON.stringify({ query: value }),
                })
                    .then((response) => response.json())
                    .then((data) => {
    
                        // Verificar si la respuesta es válida
                        if (Array.isArray(data) && data.length > 0) {
                        } else {
                        }
                    })
                    .catch((error) => {
                        console.error(`Error al enviar los datos (${key}):`, error);
                    })
                    .finally(() => {
                        isRequestInProgress[key] = false; // Marcar que la solicitud ha finalizado
                    });
            };
    
            // Configurar un intervalo para verificar cambios en el localStorage
            setInterval(checkLocalStorage, 100); // Revisa cada 500 ms
        });



        document.addEventListener('DOMContentLoaded', () => {

            document.getElementById('searchButton').addEventListener('click', () => {
                
                const radioSoloIda = document.getElementById('flight-oneway-checkbox');
                const radioIdaYRegreso = document.getElementById('flight-roundtrip-checkbox');

                if (radioSoloIda.checked) {
                    localStorage.setItem('tripMode', 1);
                } else if (radioIdaYRegreso.checked) {
                    localStorage.setItem('tripMode', 2);
                }
                
                
                // Separar las fecha de salida y llegada
                const date = document.getElementById('calendar-checkIn-flight').value.split(' - ');

                const dateOut = date[0];
                const dateIn = date[1];

                // guardar en el local 
                localStorage.setItem('startDateText', dateOut);
                localStorage.setItem('endDateText', dateIn);

                const totalPeople = document.getElementById('passengers');
                const totalPeopleArray = totalPeople.value.split(', ');
                let totalAdults = 0;
                let totalKids = 0;
                totalPeopleArray.forEach((element) => {
                    if (element.includes('Adulto')) {
                        totalAdults = parseInt(element);
                    } else {
                        totalKids = parseInt(element);
                    }
                });
                const allPeopleSum = totalAdults + totalKids;

                // guardar en el local
                localStorage.setItem('keyIdentifyForUser', 'aquihubalgo')
                localStorage.setItem('totalKids', totalKids);
                localStorage.setItem('totalAdults', totalAdults);
                localStorage.setItem('total-person-display', allPeopleSum);
            });

        });

   
    